<?php   include_once('config/db.php');   include_once('config/check.php');  

if (filter_has_var(INPUT_POST, "submit")) 
    try{
            $date =            htmlspecialchars (strtoupper($_POST['date']));
            $date =            date("Y-m-d", strtotime($date));
            $currency =                  htmlspecialchars ( $_POST['currency']);
            $rate =                  htmlspecialchars ( $_POST['rate']);
            $description =               htmlspecialchars ( $_POST['description']);

            $sql = 'INSERT INTO acccurrency_history (date,currency,rate,description,uid) VALUES(:date,:currency,:rate,:desc,:uid )';
            $conn->prepare($sql)->execute(['date' => $date,'currency'=>$currency,'rate'=>$rate,'desc'=>$description ,'uid' => $uid    ]);

            $sql = "UPDATE acccurrency SET rate=:rate,updated=:updated   WHERE id=:id";
            $conn->prepare($sql)->execute([ 'rate'=>$rate ,'updated'=>$date,'id'=>$currency  ]);
            
            header("location:addcurrencyrate.php");

        } catch(Exception $e) { echo 'Message: ' .$e->getMessage();}

?>

<!DOCTYPE html>
<html>
<head>
<?php include_once('inc/link.php');   ?>  
</head>
<body <?php include_once('inc/nav.php');  ?>>
<div class="wrapper">

  <!-- Main Header -->
    <header class="main-header">

    <!-- Logo -->
       <?php include_once('inc/brand.php');   ?>

    <!-- Header Navbar -->
    <?php include_once('inc/navbar.php');   ?>

  </header>
 
  <!-- Left side column. contains the logo and sidebar -->
    <aside class="main-sidebar">

    <!-- sidebar: style can be found in sidebar.less -->
     <?php include_once('inc/menu.php');   ?>
    <!-- /.sidebar -->
  </aside>

  <!-- Content Wrapper. Contains page content -->
  <div class="content-wrapper">

  <section class="content-header">
        <h1>   <i class="fa fa-exchange"></i>  Currency Exchange rate  Entry   </h1>
        <ol class="breadcrumb">
        <li><a href="#"><i class="fa fa-dashboard"></i> </a></li>
        <li><a href="#"> </a></li>
        <li class="active"> </li>
        <li><a href="addcurrencyrate.php" class="btn btn-default btn-sm"> <i class="fa fa-plus"></i> Add New Currency  </a></li>
        <li><a href="addcurrencyratel.php" class="btn btn-default btn-sm"> <i class="fa fa-bars"></i> View Currency Change History </a></li>
        </ol>
    </section>

<!-- Main content -->

  <section class="content container-fluid"> 
        <div class="box box-default box-xs">
            <div class="box-body">
                <div class="row">
                    <form class="form-horizontal add_form "  action="" method="post"  >
                        <div class="col-sm-12">                       
                                                               
                            <div class="col-sm-4"> 
                                <label > Select Currency </label> 
                                    <select class="form-control  js-example-basic-single   "  required="" name="currency" style="width:100%" >
                                        <?php $stmt = $conn->prepare("SELECT * FROM acccurrency  ");
                                        $stmt->execute(); foreach ($stmt as $row) {?>
                                                
                                                <option value="<?php echo $row['id']; ?>"><?php
                                                echo $row['name']; ?></option> <?php } ?>
                                    </select> 
                                    <!-- <input type="text"  name="name" value="" autocomplete="off" class="form-control"   required=""   >  -->
                            </div> 
                                                                                    
                            <div class="col-md-4">
                                <label > Date to use exchange Rate from  </label>                          
                                <input type="text" class="form-control datepicker" name="date" required="" autocomplete="off" >
                            </div>                                             
                            <div class="col-md-4">
                                <label > Exchange Rate </label>                          
                                <input type="text" class="form-control" name="rate" required="" autocomplete="off" >
                            </div>                                             
                            <div class="col-md-12">
                                <label > Remarks / Description  </label>   
                                <textarea type="text" class="form-control" name="description" required="" autocomplete="off" ></textarea>                       
                               
                            </div>                                             
                                                                         
                        </div>                           
                   
                        
                        <!-- submit button -->
                        <div class="form-group">                              
                            <div class="col-sm-offset-4 col-sm-10" style="padding-top:0.5rem;">
                                    <button type="submit"  name="submit" class="btn btn-success col-md-3">  <i class="fa fa-dollar"></i>  Update Currency exchange rate  </button> </div>
                        </div> 
                    </form>               
                </div>
            </div>
        </div>
                                
    </section>

</div>
  <!-- /.content-wrapper -->
  
  <!-- Main Footer -->
  <footer class="main-footer">
    <?php  include_once('inc/footer.php'); ?>
  </footer>
  
</div>
                         
<!-- ./wrapper -->

<!-- REQUIRED JS SCRIPTS -->
<?php include_once('inc/linkjs.php') ?>

</body>
</html>